<?php
/**
 * Admin Panel Main Interface
 * Captain Trade Bot - Professional Management Dashboard
 * Updated: 2025-10-15 16:44:53 UTC
 * Created by: saportinsta65
 */

session_start();
require_once '../config.php';
require_once '../includes/database.php';

// Check admin authentication
if (!isset($_SESSION['admin_logged_in'])) {
    if ($_POST['username'] ?? '' === ADMIN_USERNAME && 
        $_POST['password'] ?? '' === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = ADMIN_USERNAME;
        $_SESSION['login_time'] = time();
    } else {
        include 'login.php';
        exit;
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}

$db = new Database();
$stats = $db->getAdminStats();
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریت کاپیتان ترید</title>
    <meta name="description" content="پنل مدیریت حرفه‌ای ربات تلگرام کاپیتان ترید">
    <meta name="author" content="saportinsta65">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <link href="assets/admin.css" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="../assets/favicon.ico">
</head>

<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">
                <i class="bi bi-graph-up me-2"></i>
                پنل مدیریت کاپیتان ترید
            </a>
            
            <div class="d-flex align-items-center">
                <!-- Real-time stats -->
                <div class="navbar-text me-3 d-none d-md-block">
                    <small class="text-light opacity-75">
                        <i class="bi bi-people me-1"></i>
                        <span data-stat="total_users"><?= $stats['total_users'] ?></span> کاربر
                        <span class="mx-2">|</span>
                        <i class="bi bi-clock me-1"></i>
                        <span id="current-time"><?= date('H:i') ?></span>
                    </small>
                </div>
                
                <!-- Admin user dropdown -->
                <div class="dropdown">
                    <button class="btn btn-outline-light btn-sm dropdown-toggle" type="button" 
                            data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle me-1"></i>
                        <?= htmlspecialchars($_SESSION['admin_username']) ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#settings" data-tab="settings">
                            <i class="bi bi-gear me-2"></i>تنظیمات
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-danger" href="?logout=1">
                            <i class="bi bi-box-arrow-right me-2"></i>خروج
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <div class="container-fluid" style="margin-top: 76px;">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 d-md-block sidebar collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="#dashboard" data-tab="dashboard">
                                <i class="bi bi-speedometer2"></i>
                                داشبورد
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#users" data-tab="users">
                                <i class="bi bi-people"></i>
                                مدیریت کاربران
                                <span class="badge bg-primary ms-auto" data-stat="total_users"><?= $stats['total_users'] ?></span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#menus" data-tab="menus">
                                <i class="bi bi-menu-button-wide"></i>
                                مدیریت منوها
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#payments" data-tab="payments">
                                <i class="bi bi-credit-card"></i>
                                مدیریت پرداخت‌ها
                                <?php if ($stats['pending_payments'] > 0): ?>
                                    <span class="badge bg-warning ms-auto"><?= $stats['pending_payments'] ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#analytics" data-tab="analytics">
                                <i class="bi bi-bar-chart"></i>
                                آمار و گزارشات
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#broadcast" data-tab="broadcast">
                                <i class="bi bi-megaphone"></i>
                                ارسال پیام همگانی
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#settings" data-tab="settings">
                                <i class="bi bi-gear"></i>
                                تنظیمات سیستم
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#logs" data-tab="logs">
                                <i class="bi bi-file-text"></i>
                                لاگ‌ها و نظارت
                            </a>
                        </li>
                    </ul>
                    
                    <!-- System Status -->
                    <div class="mt-4 p-3 bg-light rounded">
                        <h6 class="fw-bold mb-2">وضعیت سیستم</h6>
                        <div class="d-flex justify-content-between mb-1">
                            <small>ربات:</small>
                            <small class="text-success"><i class="bi bi-circle-fill"></i> آنلاین</small>
                        </div>
                        <div class="d-flex justify-content-between mb-1">
                            <small>دیتابیس:</small>
                            <small class="text-success"><i class="bi bi-circle-fill"></i> متصل</small>
                        </div>
                        <div class="d-flex justify-content-between">
                            <small>SpotPlayer:</small>
                            <small class="text-success" id="spotplayer-status">
                                <i class="bi bi-circle-fill"></i> فعال
                            </small>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                
                <!-- Dashboard Tab -->
                <div id="dashboard" class="tab-content active">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-speedometer2 me-2"></i>
                            داشبورد مدیریت
                        </h1>
                        <div class="btn-toolbar mb-2 mb-md-0">
                            <div class="btn-group me-2">
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="exportData('users')">
                                    <i class="bi bi-download me-1"></i>
                                    خروجی کاربران
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="exportData('payments')">
                                    <i class="bi bi-download me-1"></i>
                                    خروجی پرداخت‌ها
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Stats Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col me-2">
                                            <div class="text-xs fw-bold text-primary text-uppercase mb-1">
                                                کل کاربران
                                            </div>
                                            <div class="h5 mb-0 fw-bold text-gray-800" data-stat="total_users">
                                                <?= number_format($stats['total_users']) ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="bi bi-people fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col me-2">
                                            <div class="text-xs fw-bold text-success text-uppercase mb-1">
                                                دانشجویان تایید شده
                                            </div>
                                            <div class="h5 mb-0 fw-bold text-gray-800" data-stat="verified_users">
                                                <?= number_format($stats['verified_users']) ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="bi bi-check-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col me-2">
                                            <div class="text-xs fw-bold text-info text-uppercase mb-1">
                                                کل درآمد
                                            </div>
                                            <div class="h5 mb-0 fw-bold text-gray-800" data-stat="total_revenue">
                                                <?= number_format($stats['total_revenue']) ?> تومان
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="bi bi-currency-dollar fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col me-2">
                                            <div class="text-xs fw-bold text-warning text-uppercase mb-1">
                                                ثبت‌نام امروز
                                            </div>
                                            <div class="h5 mb-0 fw-bold text-gray-800" data-stat="today_registrations">
                                                <?= number_format($stats['today_registrations']) ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="bi bi-calendar-plus fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Charts Row -->
                    <div class="row mb-4">
                        <div class="col-xl-8 col-lg-7">
                            <div class="card shadow">
                                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                                    <h6 class="m-0 fw-bold text-primary">نمودار ثبت‌نام کاربران (30 روز اخیر)</h6>
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-primary dropdown-toggle" 
                                                data-bs-toggle="dropdown">
                                            <i class="bi bi-calendar"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="#">7 روز اخیر</a></li>
                                            <li><a class="dropdown-item" href="#">30 روز اخیر</a></li>
                                            <li><a class="dropdown-item" href="#">3 ماه اخیر</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="registrationChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-4 col-lg-5">
                            <div class="card shadow">
                                <div class="card-header py-3">
                                    <h6 class="m-0 fw-bold text-primary">روش‌های پرداخت</h6>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="paymentMethodChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Activity -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 fw-bold text-primary">
                                <i class="bi bi-activity me-2"></i>
                                فعالیت‌های اخیر
                            </h6>
                            <button class="btn btn-sm btn-outline-primary" onclick="loadRecentActivities()">
                                <i class="bi bi-arrow-clockwise"></i>
                            </button>
                        </div>
                        <div class="card-body">
                            <div id="recent-activities">
                                <div class="text-center">
                                    <div class="loading"></div>
                                    <p class="mt-2">در حال بارگیری...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Users Tab -->
                <div id="users" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-people me-2"></i>
                            مدیریت کاربران
                        </h1>
                        <div class="btn-toolbar mb-2 mb-md-0">
                            <div class="input-group me-2">
                                <input type="text" class="form-control" placeholder="جستجو کاربران..." 
                                       id="userSearch" onkeyup="searchUsers(this.value)">
                                <button class="btn btn-outline-secondary" onclick="searchUsers(document.getElementById('userSearch').value)">
                                    <i class="bi bi-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="card shadow">
                        <div class="card-header">
                            <h6 class="m-0 fw-bold text-primary">لیست کاربران</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="usersTable">
                                    <thead class="table-dark">
                                        <tr>
                                            <th>نام</th>
                                            <th>نام کاربری</th>
                                            <th>شماره موبایل</th>
                                            <th>وضعیت</th>
                                            <th>تاریخ عضویت</th>
                                            <th>آخرین فعالیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="7" class="text-center">
                                                <div class="loading"></div>
                                                در حال بارگیری...
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Menus Tab -->
                <div id="menus" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-menu-button-wide me-2"></i>
                            مدیریت منوهای دانشجویی
                        </h1>
                        <button class="btn btn-primary" onclick="showAddMenuModal()">
                            <i class="bi bi-plus me-1"></i>
                            افزودن منوی جدید
                        </button>
                    </div>

                    <div class="card shadow">
                        <div class="card-header">
                            <h6 class="m-0 fw-bold text-primary">منوهای فعال</h6>
                        </div>
                        <div class="card-body">
                            <div id="menus-list">
                                <div class="text-center">
                                    <div class="loading"></div>
                                    <p class="mt-2">در حال بارگیری...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payments Tab -->
                <div id="payments" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-credit-card me-2"></i>
                            مدیریت پرداخت‌ها
                        </h1>
                        <div class="btn-group">
                            <button class="btn btn-outline-primary" onclick="loadPaymentsData('all')">همه</button>
                            <button class="btn btn-outline-warning" onclick="loadPaymentsData('pending')">در انتظار</button>
                            <button class="btn btn-outline-success" onclick="loadPaymentsData('completed')">تکمیل شده</button>
                            <button class="btn btn-outline-danger" onclick="loadPaymentsData('failed')">ناموفق</button>
                        </div>
                    </div>

                    <div class="card shadow">
                        <div class="card-header">
                            <h6 class="m-0 fw-bold text-primary">لیست پرداخت‌ها</h6>
                        </div>
                        <div class="card-body">
                            <div id="payments-container">
                                <div class="text-center">
                                    <div class="loading"></div>
                                    <p class="mt-2">در حال بارگیری...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Analytics Tab -->
                <div id="analytics" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-bar-chart me-2"></i>
                            آمار و گزارشات تفصیلی
                        </h1>
                    </div>

                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card shadow mb-4">
                                <div class="card-header">
                                    <h6 class="m-0 fw-bold text-primary">نمودار درآمد ماهانه</h6>
                                </div>
                                <div class="card-body">
                                    <canvas id="revenueChart"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card shadow mb-4">
                                <div class="card-header">
                                    <h6 class="m-0 fw-bold text-primary">محبوب‌ترین منوها</h6>
                                </div>
                                <div class="card-body">
                                    <div id="popular-menus">
                                        <div class="text-center">
                                            <div class="loading"></div>
                                            <p class="mt-2">در حال بارگیری...</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Broadcast Tab -->
                <div id="broadcast" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-megaphone me-2"></i>
                            ارسال پیام همگانی
                        </h1>
                    </div>

                    <div class="card shadow">
                        <div class="card-header">
                            <h6 class="m-0 fw-bold text-primary">ارسال پیام به کاربران</h6>
                        </div>
                        <div class="card-body">
                            <form id="broadcastForm">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">مخاطبان:</label>
                                    <select class="form-select" name="target" required>
                                        <option value="all">همه کاربران</option>
                                        <option value="verified">کاربران تایید شده</option>
                                        <option value="unverified">کاربران تایید نشده</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">متن پیام:</label>
                                    <textarea class="form-control" name="message" rows="5" 
                                              placeholder="متن پیام خود را وارد کنید..." required></textarea>
                                    <div class="form-text">
                                        از HTML و Emoji استفاده کنید. پیام به همه کاربران انتخاب شده ارسال می‌شود.
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-danger">
                                    <i class="bi bi-send me-1"></i>
                                    ارسال پیام همگانی
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Settings Tab -->
                <div id="settings" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-gear me-2"></i>
                            تنظیمات سیستم
                        </h1>
                    </div>

                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card shadow">
                                <div class="card-header">
                                    <h6 class="m-0 fw-bold text-primary">تنظیمات عمومی</h6>
                                </div>
                                <div class="card-body">
                                    <form id="settingsForm">
                                        <div id="settings-container">
                                            <div class="text-center">
                                                <div class="loading"></div>
                                                <p class="mt-2">در حال بارگیری...</p>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary mt-3">
                                            <i class="bi bi-check me-1"></i>
                                            ذخیره تنظیمات
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card shadow">
                                <div class="card-header">
                                    <h6 class="m-0 fw-bold text-primary">تست اتصالات</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <button class="btn btn-outline-primary" onclick="testSpotPlayer()">
                                            <i class="bi bi-wifi me-1"></i>
                                            تست SpotPlayer API
                                        </button>
                                        <button class="btn btn-outline-success" onclick="testTelegram()">
                                            <i class="bi bi-telegram me-1"></i>
                                            تست ربات تلگرام
                                        </button>
                                        <button class="btn btn-outline-info" onclick="testDatabase()">
                                            <i class="bi bi-database me-1"></i>
                                            تست دیتابیس
                                        </button>
                                    </div>
                                    
                                    <hr>
                                    
                                    <h6 class="fw-bold">وضعیت سیستم:</h6>
                                    <div id="system-status">
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>PHP Version:</span>
                                            <span class="text-success"><?= PHP_VERSION ?></span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Memory Usage:</span>
                                            <span class="text-info"><?= round(memory_get_usage(true)/1024/1024, 2) ?>MB</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Uptime:</span>
                                            <span class="text-primary"><?= gmdate("H:i:s", time() - $_SESSION['login_time']) ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Logs Tab -->
                <div id="logs" class="tab-content">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2">
                            <i class="bi bi-file-text me-2"></i>
                            لاگ‌ها و نظارت
                        </h1>
                    </div>

                    <div class="card shadow">
                        <div class="card-header">
                            <h6 class="m-0 fw-bold text-primary">فعالیت‌های سیستم</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>زمان</th>
                                            <th>کاربر</th>
                                            <th>عملیات</th>
                                            <th>IP</th>
                                        </tr>
                                    </thead>
                                    <tbody id="logs-table">
                                        <tr>
                                            <td colspan="4" class="text-center">
                                                <div class="loading"></div>
                                                در حال بارگیری...
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </main>
        </div>
    </div>

    <!-- Add Menu Modal -->
    <div class="modal fade" id="menuModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">افزودن منوی جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="menuForm">
                        <div class="mb-3">
                            <label class="form-label fw-bold">عنوان منو</label>
                            <input type="text" class="form-control" name="title" required 
                                   placeholder="مثال: ویدیوهای آموزشی">
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">نوع محتوا</label>
                                    <select class="form-control" name="type" required>
                                        <option value="text">متن ساده</option>
                                        <option value="link">لینک</option>
                                        <option value="file">فایل</option>
                                        <option value="video">ویدیو</option>
                                        <option value="channel">کانال</option>
                                        <option value="faq">سوالات متداول</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">آیکون</label>
                                    <input type="text" class="form-control" name="icon" 
                                           placeholder="📋" value="📋">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">محتوا</label>
                            <textarea class="form-control" name="content" rows="8" required 
                                      placeholder="محتوای منو را وارد کنید..."></textarea>
                            <div class="form-text">
                                می‌توانید از HTML و Emoji استفاده کنید.
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="button" class="btn btn-primary" onclick="saveMenu()">ذخیره</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/admin.js"></script>
    
    <script>
        // Update current time
        setInterval(function() {
            document.getElementById('current-time').textContent = new Date().toLocaleTimeString('fa-IR', {
                hour: '2-digit',
                minute: '2-digit'
            });
        }, 60000);

        // Initialize charts when analytics tab is loaded
        document.addEventListener('DOMContentLoaded', function() {
            // Test SpotPlayer connection on load
            setTimeout(testSpotPlayer, 2000);
        });

        // Additional functions
        function testTelegram() {
            // Implementation for testing Telegram bot
            showNotification('تست ربات تلگرام در حال انجام...', 'info');
        }

        function testDatabase() {
            // Implementation for testing database
            showNotification('دیتابیس به درستی متصل است', 'success');
        }

        function testSpotPlayer() {
            fetch('ajax.php?action=test_spotplayer')
                .then(response => response.json())
                .then(data => {
                    const statusElement = document.getElementById('spotplayer-status');
                    if (data.success) {
                        statusElement.innerHTML = '<i class="bi bi-circle-fill text-success"></i> فعال';
                        statusElement.className = 'text-success';
                    } else {
                        statusElement.innerHTML = '<i class="bi bi-circle-fill text-danger"></i> خطا';
                        statusElement.className = 'text-danger';
                    }
                })
                .catch(error => {
                    document.getElementById('spotplayer-status').innerHTML = '<i class="bi bi-circle-fill text-danger"></i> خطا';
                });
        }

        // Search users function
        function searchUsers(term) {
            if (term.length < 2) {
                loadUsersData();
                return;
            }
            
            searchData(term, 'users');
        }

        // Handle broadcast form
        document.getElementById('broadcastForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (!confirm('آیا از ارسال پیام به همه کاربران انتخاب شده اطمینان دارید؟')) {
                return;
            }
            
            const formData = new FormData(this);
            formData.append('action', 'send_broadcast');
            
            fetch('ajax.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showNotification(`پیام به ${data.sent} کاربر ارسال شد (${data.failed} ناموفق)`, 'success');
                    document.getElementById('broadcastForm').reset();
                } else {
                    showNotification('خطا در ارسال پیام: ' + (data.error || 'خطای نامشخص'), 'error');
                }
            })
            .catch(error => {
                console.error('Error sending broadcast:', error);
                showNotification('خطا در ارسال پیام', 'error');
            });
        });
    </script>
</body>
</html>