<?php
/**
 * مدیریت کاربران عادی ربات
 * نسخه ساده و کارآمد - 29 سپتامبر 2025
 */

require_once 'functions.php';
require_once 'referral.php';
require_once 'exercises.php';
require_once 'campaign.php';

// دکمه‌ها و متون سفارشی
$btn_captain = loadBtnCaptain();
$btn_advanced = loadBtnAdvanced();

/**
 * تولید کیبورد اصلی بر اساس وضعیت کاربر
 */
function getMainKeyboard($user_id) {
    global $btn_advanced, $btn_captain;
    
    try {
        $refCount = getReferralCount($user_id);
        
        $mainKeyboard = [
            ["🎓 ثبت‌نام دوره رایگان"],
            [$btn_advanced['btn']],
            ["📊 آمار دعوت‌ها"],
            [$btn_captain['btn']],
            ["💬 پشتیبانی آنلاین"]
        ];
        
        // دکمه ویژه برای کاربران ۲۰+ دعوت
        if ($refCount >= MIN_REFERRALS_FOR_ADVANCED_DISCOUNT) {
            $mainKeyboard[] = ["🚀 ثبت‌نام ویژه پیشرفته با تخفیف"];
        }
        
        return $mainKeyboard;
    } catch (Exception $e) {
        error_log("Error generating main keyboard for user $user_id: " . $e->getMessage());
        return [
            ["🎓 ثبت‌نام دوره رایگان"],
            [$btn_advanced['btn']],
            [$btn_captain['btn']],
            ["💬 پشتیبانی آنلاین"]
        ];
    }
}

/**
 * پیام خوش‌آمدگویی
 */
function welcomeMessage($user_id) {
    try {
        $user = getUserById($user_id);
        $name = $user['first_name'] ?? 'کاربر گرامی';
        $total_users = count(loadUsers());
        $stats = getReferralStats($user_id);
        
        $message = "👋 سلام <b>$name</b> عزیز!\n\n"
            . "به ربات آموزشی <b>کاپیتان تریدر</b> خوش اومدی! 🚀\n\n"
            . "تا این لحظه <b>$total_users نفر</b> به ربات پیوسته‌اند!\n\n"
            . "در این ربات، قراره با هم یک دوره رایگان و حرفه‌ای رو قدم به قدم پیش بریم و به دنیای معامله‌گری حرفه‌ای وارد بشیم!\n\n"
            . "✅ <b>مزایای ربات:</b>\n"
            . "✔️ آموزش صفر تا صد فارکس و پراپ‌فرم\n"
            . "✔️ استراتژی شخصی کاپیتان برای موفقیت\n"
            . "✔️ بکتست‌گیری، ژورنال‌نویسی و پلن معاملاتی حرفه‌ای\n"
            . "✔️ پشتیبانی آنلاین و پاسخ به سوالات شما\n\n";
        
        // اضافه کردن آمار شخصی
        if ($stats['total'] > 0) {
            $message .= "📈 <b>آمار شما:</b>\n";
            $message .= "👥 تعداد دعوت‌ها: <b>{$stats['total']}</b>\n";
            
            if ($stats['can_access_free']) {
                $message .= "✅ دسترسی به دوره رایگان: <b>فعال</b>\n";
            } else {
                $message .= "⏳ برای دوره رایگان: <b>{$stats['needed_for_free']} دعوت باقی‌مانده</b>\n";
            }
            
            if ($stats['can_access_discount']) {
                $message .= "🎯 تخفیف دوره پیشرفته: <b>فعال</b>\n";
            }
            
            $message .= "\n";
        }
        
        $message .= "برای شروع، روی دکمه‌ها کلیک کن.";
        
        return $message;
    } catch (Exception $e) {
        error_log("Error generating welcome message for user $user_id: " . $e->getMessage());
        return "👋 خوش آمدید! برای شروع، روی دکمه‌ها کلیک کنید.";
    }
}

/**
 * ارسال درخواست شماره تماس
 */
function sendContactBtn($chat_id, $user_id) {
    $btn = [
        [
            [
                "text" => "ارسال شماره موبایل 📱",
                "request_contact" => true
            ]
        ]
    ];
    sendMessage($chat_id, welcomeMessage($user_id) . "\n\nلطفاً شماره موبایل خود را ارسال کن:", $btn);
}

/**
 * ارسال درخواست عضویت در کانال‌ها
 */
function sendJoinChannels($chat_id) {
    $btn = [
        [
            [
                "text" => "عضویت در کانال اول 📢",
                "url" => "https://t.me/" . str_replace('@', '', CHANNEL1)
            ],
            [
                "text" => "عضویت در کانال دوم 📢",
                "url" => "https://t.me/" . str_replace('@', '', CHANNEL2)
            ]
        ],
        [
            [
                "text" => "عضو شدم ✅"
            ]
        ]
    ];
    sendMessage($chat_id, "برای ادامه باید عضو هر دو کانال زیر باشید 👇\n\n🔗 کانال اول: " . CHANNEL1 . "\n🔗 کانال دوم: " . CHANNEL2, $btn);
}

/**
 * نمایش آمار دعوت‌ها
 */
function showReferralStats($chat_id, $user_id) {
    try {
        $stats = getReferralStats($user_id);
        $rank = getUserReferralRank($user_id);
        
        $message = "📊 <b>آمار دعوت‌های شما</b>\n\n";
        
        // آمار کلی
        $message .= "👥 <b>تعداد کل دعوت‌ها:</b> {$stats['total']}\n";
        $message .= "📅 امروز: {$stats['today']} | این هفته: {$stats['this_week']} | این ماه: {$stats['this_month']}\n\n";
        
        // رتبه
        $message .= "🏆 <b>رتبه شما:</b> {$rank['rank']} از {$rank['total_referrers']}\n\n";
        
        // وضعیت دسترسی‌ها
        $message .= "🎯 <b>وضعیت دسترسی‌ها:</b>\n";
        
        if ($stats['can_access_free']) {
            $message .= "✅ دوره رایگان: <b>فعال</b>\n";
        } else {
            $message .= "⏳ دوره رایگان: <b>{$stats['needed_for_free']} دعوت باقی‌مانده</b>\n";
        }
        
        if ($stats['can_access_discount']) {
            $message .= "✅ تخفیف دوره پیشرفته: <b>فعال</b>\n";
        } else {
            $message .= "⏳ تخفیف دوره پیشرفته: <b>{$stats['needed_for_discount']} دعوت باقی‌مانده</b>\n";
        }
        
        $message .= "\n🔗 <b>لینک دعوت شما:</b>\n" . getReferralLink($user_id);
        
        // نمایش آخرین دعوت‌ها
        if (!empty($stats['referrals'])) {
            $message .= "\n\n👥 <b>آخرین دعوت‌ها:</b>\n";
            $recent = array_slice($stats['referrals'], 0, 5);
            foreach ($recent as $ref) {
                $date = date('m/d H:i', strtotime($ref['date']));
                $message .= "▪️ {$ref['name']} - $date\n";
            }
            
            if (count($stats['referrals']) > 5) {
                $remaining = count($stats['referrals']) - 5;
                $message .= "... و $remaining نفر دیگر\n";
            }
        }
        
        $keyboard = [
            ["🎁 دریافت بنر تبلیغاتی"],
            ["بازگشت"]
        ];
        
        sendMessage($chat_id, $message, $keyboard);
    } catch (Exception $e) {
        error_log("Error showing referral stats for user $user_id: " . $e->getMessage());
        sendMessage($chat_id, "❌ خطا در دریافت آمار. لطفاً دوباره تلاش کنید.", [["بازگشت"]]);
    }
}

/**
 * ارسال بنر تبلیغاتی
 */
function sendInviteBannerToUser($chat_id, $user_id) {
    try {
        $banner = getInviteBanner($user_id);
        
        // ارسال عکس
        if (!empty($banner['photo'])) {
            sendFile($chat_id, 'photo', $banner['photo'], '🎁 بنر تبلیغاتی شما');
        }
        
        // ارسال متن
        sendMessage($chat_id, $banner['text'], [["بازگشت"]]);
        
        // راهنمای استفاده
        $guide = "📝 <b>راهنمای استفاده:</b>\n\n"
            . "1️⃣ عکس و متن بالا را کپی کنید\n"
            . "2️⃣ در گروه‌ها، کانال‌ها یا برای دوستان ارسال کنید\n"
            . "3️⃣ هر نفری که با لینک شما وارد شود، به آمار شما اضافه می‌شود\n"
            . "4️⃣ با ۵ دعوت، دوره رایگان فعال می‌شود\n"
            . "5️⃣ با ۲۰ دعوت، تخفیف ویژه دوره پیشرفته فعال می‌شود";
        
        sendMessage($chat_id, $guide, [["بازگشت"]]);
    } catch (Exception $e) {
        error_log("Error sending invite banner to user $user_id: " . $e->getMessage());
        sendMessage($chat_id, "❌ خطا در ارسال بنر. لطفاً دوباره تلاش کنید.", [["بازگشت"]]);
    }
}

/**
 * دریافت لیست نام جلسات
 */
function getSessionTitles() {
    $sessions = loadSessions();
    $titles = [];
    foreach ($sessions as $sess) {
        $titles[] = $sess['title'];
    }
    return $titles;
}

/**
 * هندل کاربران عادی - نسخه ساده شده
 */
function handleUser($message, $chat_id, $text, $user_id) {
    global $btn_captain, $btn_advanced;

    try {
        $user = getUserById($user_id);
        $user_mobile = isset($user['mobile']) ? $user['mobile'] : null;
        $is_admin = ($user_id == ADMIN_ID);

        // بررسی استارت با لینک معرف
        if (isset($message['text']) && strpos($message['text'], "/start") === 0) {
            $params = explode(" ", $message['text']);
            if (isset($params[1])) {
                $ref_id = intval($params[1]);
                if (handleReferralStart($user_id, $ref_id)) {
                    error_log("User $user_id registered with referrer $ref_id");
                }
            }
            
            registerUser([
                'id' => $user_id,
                'first_name' => $message['from']['first_name'] ?? '',
                'username' => $message['from']['username'] ?? '',
                'type' => 'user'
            ]);
            
            sendMessage($chat_id, welcomeMessage($user_id), getMainKeyboard($user_id));
            return true;
        }

        // لغو عملیات
        if ($text == "/cancel") {
            if ($is_admin) {
                sendMessage($chat_id, "❌ عملیات لغو شد. به منوی مدیریت برگشتید.", [["پنل مدیریت"]]);
            } else {
                sendMessage($chat_id, "❌ عملیات لغو شد. به منوی اصلی برگشتید.", getMainKeyboard($user_id));
            }
            
            $support_state = loadSupportState();
            unset($support_state[$user_id]);
            saveSupportState($support_state);
            return true;
        }

        // بررسی شماره موبایل
        if (!$is_admin && empty($user_mobile) && !isset($message['contact'])) {
            if ($text == "/start" || $text == "بازگشت") {
                sendContactBtn($chat_id, $user_id);
                return true;
            }
            sendContactBtn($chat_id, $user_id);
            return true;
        }

        // دریافت شماره تماس
        if (isset($message['contact']) && $message['contact']['phone_number']) {
            $mobile = $message['contact']['phone_number'];
            registerUser([
                'id' => $user_id,
                'first_name' => $message['from']['first_name'] ?? '',
                'username' => $message['from']['username'] ?? '',
                'type' => 'user',
                'mobile' => $mobile
            ]);
            sendJoinChannels($chat_id);
            return true;
        }

        // بررسی عضویت در کانال‌ها
        if (!$is_admin && (empty($user['channels_checked']) || intval($user['channels_checked']) == 0)) {
            if ($text == "عضو شدم ✅") {
                $joined1 = checkChannelMember($user_id, CHANNEL1);
                $joined2 = checkChannelMember($user_id, CHANNEL2);
                
                if ($joined1 && $joined2) {
                    $user['channels_checked'] = 1;
                    saveUser($user);
                    sendMessage($chat_id, "✅ عضویت شما تایید شد! به منوی ربات خوش آمدید:", getMainKeyboard($user_id));
                } else {
                    sendJoinChannels($chat_id);
                    sendMessage($chat_id, "❌ باید عضو هر دو کانال باشید.\nلطفاً دوباره عضو شوید و سپس دکمه 'عضو شدم' را بزن.");
                }
                return true;
            }
            sendJoinChannels($chat_id);
            return true;
        }

        // پشتیبانی آنلاین
        $support_state = loadSupportState();
        if (isset($support_state[$user_id]) && $support_state[$user_id] == "waiting_for_reply") {
            if ($text || isset($message['photo']) || isset($message['voice'])) {
                $from = $message['from']['first_name'] ?? 'کاربر';
                $reply_markup = [
                    'inline_keyboard' => [
                        [
                            [
                                'text' => '✉️ پاسخ به کاربر',
                                'callback_data' => "support_reply_" . $user_id
                            ]
                        ]
                    ]
                ];
                
                if ($text) {
                    sendMessage(ADMIN_ID, "📩 <b>پیام جدید از $from</b>\n👤 ID: <code>$user_id</code>\n\n💬 پیام:\n$text", null);
                }
                
                if (isset($message['photo'])) {
                    $photos = $message['photo'];
                    $file_id = $photos[count($photos) - 1]['file_id'];
                    sendFile(ADMIN_ID, 'photo', $file_id, "📩 عکس از $from (ID: $user_id)");
                }
                
                if (isset($message['voice'])) {
                    $file_id = $message['voice']['file_id'];
                    sendFile(ADMIN_ID, 'voice', $file_id, "📩 ویس از $from (ID: $user_id)");
                }
                
                $url = API_URL . "sendMessage?" . http_build_query([
                    'chat_id' => ADMIN_ID,
                    'text' => "پاسخ به همین کاربر:",
                    'reply_markup' => json_encode($reply_markup)
                ]);
                file_get_contents($url);
                
                sendMessage($chat_id, "✅ پیام شما برای پشتیبانی ارسال شد. منتظر پاسخ بمانید.", [["بازگشت"]]);
            } else {
                sendMessage($chat_id, "فقط پیام متنی، عکس یا ویس مجاز است.", [["بازگشت"]]);
            }
            
            unset($support_state[$user_id]);
            saveSupportState($support_state);
            return true;
        }

        // شروع پشتیبانی
        if ($text == "💬 پشتیبانی آنلاین") {
            $support_state[$user_id] = "waiting_for_reply";
            saveSupportState($support_state);
            sendMessage($chat_id, "📝 لطفاً پیام خود را برای پشتیبانی ارسال کنید (متن، عکس یا ویس).", [["بازگشت"]]);
            return true;
        }

        // منوهای اصلی (بعد از تکمیل فرآیند عضویت)
        if (!empty($user['channels_checked'])) {
            
            // دوره رایگان
            if ($text == "🎓 ثبت‌نام دوره رایگان") {
                $stats = getReferralStats($user_id);
                
                if ($stats['can_access_free']) {
                    registerUser([
                        'id' => $user_id,
                        'first_name' => $message['from']['first_name'] ?? '',
                        'username' => $message['from']['username'] ?? '',
                        'type' => 'free'
                    ]);
                    
                    $sessions = loadSessions();
                    if (count($sessions) > 0) {
                        $sessionBtns = [];
                        foreach ($sessions as $sess) {
                            $sessionBtns[] = [$sess['title']];
                        }
                        $sessionBtns[] = ["📊 آمار دعوت‌ها"];
                        $sessionBtns[] = ["بازگشت"];
                        
                        sendMessage($chat_id, "✅ ثبت‌نام شما در <b>دوره رایگان فارکس</b> انجام شد!\n\n🎬 جلسات آموزشی زیر آماده است:", $sessionBtns);
                    } else {
                        sendMessage($chat_id, "❌ هنوز جلسات آموزشی توسط ادمین تعریف نشده است.", getMainKeyboard($user_id));
                    }
                } else {
                    $msg = "⛔️ <b>دسترسی به دوره رایگان فرمول ۵ مرحله‌ای کاپیتان!</b>\n\n"
                        . "برای استفاده از این دوره ارزشمند باید حداقل <b>" . MIN_REFERRALS_FOR_FREE_COURSE . " نفر</b> را با لینک دعوت اختصاصی خودت به ربات معرفی کنی.\n\n"
                        . "📊 وضعیت فعلی شما:\n"
                        . "✅ تعداد دعوت موفق: <b>{$stats['total']}</b> نفر\n"
                        . "⏳ باقی‌مانده: <b>{$stats['needed_for_free']}</b> نفر\n\n"
                        . "🔗 لینک اختصاصی تو:\n"
                        . getReferralLink($user_id);

                    sendMessage($chat_id, $msg, [["🎁 دریافت بنر تبلیغاتی"], ["📊 آمار دعوت‌ها"], ["بازگشت"]]);
                }
                return true;
            }

            // آمار دعوت‌ها
            if ($text == "📊 آمار دعوت‌ها") {
                showReferralStats($chat_id, $user_id);
                return true;
            }

            // دریافت بنر تبلیغاتی
            if ($text == "🎁 دریافت بنر تبلیغاتی") {
                sendInviteBannerToUser($chat_id, $user_id);
                return true;
            }

            // ثبت‌نام ویژه با تخفیف
            if ($text == "🚀 ثبت‌نام ویژه پیشرفته با تخفیف") {
                $refCount = getReferralCount($user_id);
                if ($refCount >= MIN_REFERRALS_FOR_ADVANCED_DISCOUNT) {
                    registerUser([
                        'id' => $user_id,
                        'first_name' => $message['from']['first_name'] ?? '',
                        'username' => $message['from']['username'] ?? '',
                        'type' => 'pls_discount'
                    ]);
                    sendMessage($chat_id, "🎉 تبریک! شما با دعوت $refCount نفر، واجد شرایط ثبت‌نام دوره پیشرفته با تخفیف شدید!\n\nجهت ثبت‌نام و دریافت تخفیف، به پشتیبانی پیام دهید.", getMainKeyboard($user_id));
                } else {
                    $needed = MIN_REFERRALS_FOR_ADVANCED_DISCOUNT - $refCount;
                    sendMessage($chat_id, "⚠️ برای استفاده از تخفیف باید حداقل " . MIN_REFERRALS_FOR_ADVANCED_DISCOUNT . " نفر را دعوت کنید.\n\n📊 وضعیت فعلی شما:\n▪️ دعوت‌شده: <b>$refCount</b> نفر\n▪️ باقی‌مانده: <b>$needed</b> نفر", getMainKeyboard($user_id));
                }
                return true;
            }

            // دکمه‌های سفارشی
            if ($text == $btn_advanced['btn']) {
                registerUser([
                    'id' => $user_id,
                    'first_name' => $message['from']['first_name'] ?? '',
                    'username' => $message['from']['username'] ?? '',
                    'type' => 'pls'
                ]);
                sendMessage($chat_id, $btn_advanced['msg'], getMainKeyboard($user_id));
                return true;
            }

            if ($text == $btn_captain['btn']) {
                sendMessage($chat_id, $btn_captain['msg'], getMainKeyboard($user_id));
                return true;
            }

            // **🎯 جلسات دوره - منطق اصلاح شده**
            $session_titles = getSessionTitles();
            if (in_array($text, $session_titles)) {
                $sessions = loadSessions();
                foreach ($sessions as $sess) {
                    if ($text == $sess['title']) {
                        // بررسی دسترسی به جلسه
                        if (!canSeeNextSession($user_id, $sess['title'])) {
                            sendMessage($chat_id, "⛔️ تمرین جلسه قبلی شما هنوز تایید نشده است.\n\nابتدا تمرین را به درستی ارسال کنید و منتظر تایید ادمین باشید.", [["بازگشت"]]);
                            return true;
                        }

                        // ثبت مشاهده جلسه
                        markSessionSeen($user_id, $sess['title']);

                        // ارسال محتوای جلسه
                        $msg = "🎓 <b>{$sess['title']}</b>";
                        if (isset($sess['text']) && strlen(trim($sess['text'])) > 0) {
                            $msg .= "\n\n" . $sess['text'];
                        }
                        sendMessage($chat_id, $msg, [["بازگشت"]]);

                        // ارسال فایل‌های جلسه
                        if (!empty($sess['files'])) {
                            foreach ($sess['files'] as $file) {
                                if ($file['type'] == 'text') {
                                    sendMessage($chat_id, $file['content']);
                                } else {
                                    $caption = isset($file['caption']) && $file['caption'] !== "" ? $file['caption'] : $sess['title'];
                                    sendFile($chat_id, $file['type'], $file['file_id'], $caption);
                                }
                            }
                        }

                        // ارسال تمرین (اگر وجود دارد)
                        sendExercise($user_id, $sess['title']);
                        return true;
                    }
                }
            }

            // **🔥 هندل پاسخ تمرین - در انتها**
            if ($text && 
                $text != "/start" && 
                $text != "بازگشت" && 
                $text != "📊 آمار دعوت‌ها" && 
                $text != "🎁 دریافت بنر تبلیغاتی" && 
                $text != "💬 پشتیبانی آنلاین" &&
                $text != "🎓 ثبت‌نام دوره رایگان" &&
                $text != $btn_captain['btn'] &&
                $text != $btn_advanced['btn'] &&
                $text != "🚀 ثبت‌نام ویژه پیشرفته با تخفیف" &&
                $text != "عضو شدم ✅" &&
                !in_array($text, $session_titles)) {
                
                // بررسی اینکه کاربر تمرینی برای پاسخ دارد
                $sessions = loadSessions();
                $exercises = isset($user['exercises']) ? 
                    (is_string($user['exercises']) ? json_decode($user['exercises'], true) : $user['exercises']) : [];
                $seen_sessions = isset($user['seen_sessions']) ? 
                    (is_string($user['seen_sessions']) ? json_decode($user['seen_sessions'], true) : $user['seen_sessions']) : [];

                foreach ($sessions as $sess) {
                    if (is_array($seen_sessions) && in_array($sess['title'], $seen_sessions)) {
                        $session_id = $sess['id'];
                        
                        if (!isset($exercises[$session_id]) ||
                            ($exercises[$session_id]['status'] == 'pending' || $exercises[$session_id]['status'] == 'rejected')) {
                            
                            if (handleExerciseAnswer($user_id, $sess['title'], $text)) {
                                sendMessage($chat_id, "✅ پاسخ تمرین شما ثبت شد و برای ادمین ارسال شد.\n\nمنتظر بررسی و تایید باشید.", [["بازگشت"]]);
                                return true;
                            }
                        }
                    }
                }
            }

            // بازگشت به منوی اصلی
            if ($text == "/start" || $text == "بازگشت") {
                sendMessage($chat_id, welcomeMessage($user_id), getMainKeyboard($user_id));
                return true;
            }
        } else {
            // کاربر هنوز فرآیند عضویت را تکمیل نکرده
            if ($text == "/start" || $text == "بازگشت") {
                if (empty($user_mobile)) {
                    sendContactBtn($chat_id, $user_id);
                } else {
                    sendJoinChannels($chat_id);
                }
                return true;
            }
        }

        // پیام راهنما برای پیام‌های نامشخص
        sendMessage($chat_id, "❔ لطفا یکی از گزینه‌های منو را انتخاب کنید.", getMainKeyboard($user_id));
        return true;

    } catch (Exception $e) {
        error_log("Error in handleUser for user $user_id: " . $e->getMessage());
        sendMessage($chat_id, "❌ خطایی رخ داد. لطفاً دوباره تلاش کنید.", getMainKeyboard($user_id));
        return true;
    }
}
?>