<?php
/**
 * ═══════════════════════════════════════════════════
 * 🤖 ربات رابین هک - Bot Main File
 * ═══════════════════════════════════════════════════
 * Version: 2.1
 * Developer: Professional Team
 * Last Update: 2025-10-12
 * Website: https://capitanbours.ir/rabinhk
 * ═══════════════════════════════════════════════════
 */

// Load configurations
require_once __DIR__ . '/config.php';
require_once HELPERS_DIR . 'database.php';
require_once HELPERS_DIR . 'copywriting.php';
require_once MODULES_DIR . 'order_tracking.php';
require_once MODULES_DIR . 'payment_gateway.php';
require_once MODULES_DIR . 'faq_system.php';

// Get update
$content = file_get_contents("php://input");
$update = json_decode($content, true);

$message = $update['message'] ?? null;
$callback = $update['callback_query'] ?? null;

// ═══════════════════════════════════════════════════
// 📨 MESSAGE HANDLER
// ═══════════════════════════════════════════════════

if($message) {
    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'];
    $text = $message['text'] ?? '';
    $username = $message['from']['username'] ?? '';
    $first_name = $message['from']['first_name'] ?? '';
    
    $is_admin = ($user_id == ADMIN_ID);
    
    // ─────────────────────────────────────────────────
    // بررسی عضویت در کانال
    // ─────────────────────────────────────────────────
    
    if(!isUserInChannel($user_id)) {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "
📢 <b>برای استفاده از ربات، ابتدا در کانال ما عضو شوید:</b>

👉 " . CHANNEL_USERNAME . "

سپس روی دکمه «بررسی عضویت» کلیک کنید تا بتوانید از خدمات استفاده کنید.

━━━━━━━━━━━━━━━━━━━━
🎁 با عضویت در کانال از تخفیف‌ها و اخبار ویژه باخبر شوید!
",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '🔗 عضویت در کانال', 'url' => 'https://t.me/' . str_replace('@', '', CHANNEL_USERNAME)]],
                    [['text' => '✅ بررسی عضویت', 'callback_data' => 'check_channel']]
                ]
            ])
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // ذخیره کاربر جدید
    // ─────────────────────────────────────────────────
    
    if(saveUser($user_id, $username, $first_name)) {
        // کاربر جدید است - ارسال پیام خوش‌آمدگویی
        logActivity("New user joined: $user_id ($first_name)");
    }
    
    // ─────────────────────────────────────────────────
    // 🔥 پاسخ ادمین به کاربران
    // ─────────────────────────────────────────────────
    
    $reply_mode_file = DATA_DIR . 'admin_reply_mode.txt';
    
    // اگر ادمین در حالت پاسخ است
    if($is_admin && file_exists($reply_mode_file)) {
        $target_user = trim(file_get_contents($reply_mode_file));
        unlink($reply_mode_file);
        
        // فوروارد تمام انواع پیام به کاربر
        if(isset($message['photo'])) {
            $photo = end($message['photo']);
            apiRequest('sendPhoto', [
                'chat_id' => $target_user,
                'photo' => $photo['file_id'],
                'caption' => "📩 <b>پاسخ از پشتیبانی:</b>\n\n" . ($message['caption'] ?? ''),
                'parse_mode' => 'HTML'
            ]);
        } elseif(isset($message['video'])) {
            apiRequest('sendVideo', [
                'chat_id' => $target_user,
                'video' => $message['video']['file_id'],
                'caption' => "📩 <b>پاسخ از پشتیبانی:</b>\n\n" . ($message['caption'] ?? ''),
                'parse_mode' => 'HTML'
            ]);
        } elseif(isset($message['voice'])) {
            apiRequest('sendVoice', [
                'chat_id' => $target_user,
                'voice' => $message['voice']['file_id'],
                'caption' => "📩 <b>پاسخ از پشتیبانی</b>",
                'parse_mode' => 'HTML'
            ]);
        } elseif(isset($message['document'])) {
            apiRequest('sendDocument', [
                'chat_id' => $target_user,
                'document' => $message['document']['file_id'],
                'caption' => "📩 <b>پاسخ از پشتیبانی:</b>\n\n" . ($message['caption'] ?? ''),
                'parse_mode' => 'HTML'
            ]);
        } else {
            // پیام متنی
            apiRequest('sendMessage', [
                'chat_id' => $target_user,
                'text' => "
📩 <b>پاسخ از پشتیبانی:</b>

$text

━━━━━━━━━━━━━━━━━━━━
💬 سوال دیگری دارید؟ پیام خود را ارسال کنید.
",
                'parse_mode' => 'HTML'
            ]);
        }
        
        // تایید برای ادمین
        apiRequest('sendMessage', [
            'chat_id' => ADMIN_ID,
            'text' => "✅ پاسخ شما برای کاربر <code>$target_user</code> ارسال شد.",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '👨‍💼 پنل مدیریت']],
                    [['text' => '🏠 منوی اصلی']]
                ],
                'resize_keyboard' => true
            ])
        ]);
        
        logActivity("Admin replied to user $target_user");
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // پردازش رسید پرداخت
    // ─────────────────────────────────────────────────
    
    if(processReceiptUpload($chat_id, $user_id, $message)) {
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // منوی اصلی و بازگشت
    // ─────────────────────────────────────────────────
    
    if($text == '/start' || $text == '🏠 منوی اصلی' || $text == '🔙 بازگشت') {
        // پاک کردن حالت‌های فعال
        if(file_exists($reply_mode_file)) unlink($reply_mode_file);
        
        $welcome_msg = getWelcomeMessage($first_name);
        
        $keyboard = [
            [['text' => '💼 خدمات ما'], ['text' => '📦 سفارشات من']],
            [['text' => '📢 نمونه‌کار'], ['text' => '❓ سوالات متداول']],
            [['text' => '💬 پشتیبانی'], ['text' => '📊 درباره ما']],
        ];
        
        if($is_admin) {
            $keyboard[] = [['text' => '👨‍💼 پنل مدیریت']];
        }
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $welcome_msg,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'keyboard' => $keyboard,
                'resize_keyboard' => true
            ])
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // خدمات
    // ─────────────────────────────────────────────────
    
    if($text == '💼 خدمات ما') {
        $keyboard = [
            [['text' => '🕵️ هک شبکه‌های اجتماعی']],
            [['text' => '🛡️ امنیت اینستاگرام']],
            [['text' => '🔙 بازگشت']]
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "
💼 <b>خدمات ربات رابین هک</b>

لطفاً یکی از خدمات زیر را انتخاب کنید:

━━━━━━━━━━━━━━━━━━━━
🕵️ <b>هک شبکه‌های اجتماعی</b>
دسترسی به تلگرام، اینستاگرام و...

🛡️ <b>امنیت اینستاگرام</b>
بازگردانی پیج، حذف فیک، ضد هک

━━━━━━━━━━━━━━━━━━━━
🎁 تخفیف ویژه اولین خرید: ۲۰٪
",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'keyboard' => $keyboard,
                'resize_keyboard' => true
            ])
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // سرویس هک
    // ─────────────────────────────────────────────────
    
    if($text == '🕵️ هک شبکه‌های اجتماعی') {
        $user_orders = getUserOrders($user_id);
        $is_first = empty($user_orders);
        
        $message_text = getHackServiceMessage($is_first);
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $message_text,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '🛒 خرید سرویس', 'callback_data' => 'buy_hack']],
                    [['text' => '💬 مشاوره رایگان', 'callback_data' => 'contact_support']],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'back_services']]
                ]
            ])
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // سرویس امنیت
    // ─────────────────────────────────────────────────
    
    if($text == '🛡️ امنیت اینستاگرام') {
        $user_orders = getUserOrders($user_id);
        $is_first = empty($user_orders);
        
        $message_text = getSecurityServiceMessage($is_first);
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $message_text,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '🛒 خرید سرویس', 'callback_data' => 'buy_security']],
                    [['text' => '💬 مشاوره رایگان', 'callback_data' => 'contact_support']],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'back_services']]
                ]
            ])
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // سفارشات من
    // ─────────────────────────────────────────────────
    
    if($text == '📦 سفارشات من') {
        showUserOrders($chat_id, $user_id);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // نمونه کار
    // ─────────────────────────────────────────────────
    
    if($text == '📢 نمونه‌کار') {
        $social_proof = getSocialProofMessage();
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $social_proof,
            'parse_mode' => 'HTML'
        ]);
        
        // ارسال نمونه‌های متنی
        if(file_exists(EXAMPLES_FILE)) {
            $examples = file_get_contents(EXAMPLES_FILE);
            apiRequest('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "📝 <b>نمونه کارهای متنی:</b>\n\n$examples",
                'parse_mode' => 'HTML'
            ]);
        }
        
        // ارسال مدیا
        if(is_dir(EXAMPLES_MEDIA_DIR)) {
            foreach(glob(EXAMPLES_MEDIA_DIR . "*") as $file) {
                $parts = explode('.', basename($file));
                $type = end($parts);
                $fid = file_get_contents($file);
                
                if($type == 'photo') {
                    apiRequest('sendPhoto', ['chat_id' => $chat_id, 'photo' => $fid]);
                } elseif($type == 'video') {
                    apiRequest('sendVideo', ['chat_id' => $chat_id, 'video' => $fid]);
                } elseif($type == 'voice') {
                    apiRequest('sendVoice', ['chat_id' => $chat_id, 'voice' => $fid]);
                }
            }
        }
        
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // FAQ
    // ─────────────────────────────────────────────────
    
    if($text == '❓ سوالات متداول') {
        showFAQCategories($chat_id);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // پشتیبانی
    // ─────────────────────────────────────────────────
    
    if($text == '💬 پشتیبانی') {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "
💬 <b>پشتیبانی ۲۴/۷ ربات رابین هک</b>

━━━━━━━━━━━━━━━━━━━━
📝 پیام خود را ارسال کنید (متن، عکس، ویس یا فایل)

✅ تیم ما در اسرع وقت پاسخگو خواهد بود
⏰ زمان پاسخ: معمولاً کمتر از ۳۰ دقیقه

━━━━━━━━━━━━━━━━━━━━
💡 <b>نکته:</b> برای پاسخ سریع‌تر، سوال خود را واضح و کامل بپرسید.
",
            'parse_mode' => 'HTML'
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // درباره ما
    // ─────────────────────────────────────────────────
    
    if($text == '📊 درباره ما') {
        $stats = getStats();
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "
📊 <b>درباره ربات رابین هک</b>

━━━━━━━━━━━━━━━━━━━━
🏆 <b>تیم حرفه‌ای با بیش از ۵ سال تجربه</b>

✅ نرخ موفقیت: ۹۸٪
✅ مشتریان راضی: +{$stats['completed_orders']} نفر
✅ پشتیبانی: ۲۴/۷
✅ تضمین: بازگشت ۱۰۰٪ وجه

━━━━━━━━━━━━━━━━━━━━
🎯 <b>مأموریت ما:</b>
ارائه خدمات امنیتی و فنی با بالاترین کیفیت و کمترین قیمت

━━━━━━━━━━━━━━━━━━━━
📞 <b>ارتباط با ما:</b>
کانال: " . CHANNEL_USERNAME . "
پشتیبانی: از طریق همین ربات
",
            'parse_mode' => 'HTML'
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // پنل مدیریت (فقط ادمین)
    // ─────────────────────────────────────────────────
    
    if($is_admin && $text == '👨‍💼 پنل مدیریت') {
        $stats = getStats();
        
        $message = "
👨‍💼 <b>پنل مدیریت ربات</b>

━━━━━━━━━━━━━━━━━━━━
📊 <b>آمار کلی:</b>

👥 کل کاربران: {$stats['total_users']}
📦 کل سفارشات: {$stats['total_orders']}
💰 کل درآمد: " . number_format($stats['total_revenue']) . " تومان
📈 نرخ تبدیل: {$stats['conversion_rate']}%

━━━━━━━━━━━━━━━━━━━━
📅 <b>امروز:</b>
👤 کاربران جدید: {$stats['users_today']}
🛒 سفارشات: {$stats['orders_today']}

━━━━━━━━━━━━━━━━━━━━
⏳ سفارشات در انتظار: {$stats['pending_orders']}
✅ سفارشات تکمیل شده: {$stats['completed_orders']}
";
        
        $keyboard = [
            [['text' => '📦 مدیریت سفارشات', 'callback_data' => 'admin_orders']],
            [['text' => '👥 لیست کاربران', 'callback_data' => 'admin_users'], ['text' => '📊 آمار کامل', 'callback_data' => 'admin_stats']],
            [['text' => '❓ مدیریت FAQ', 'callback_data' => 'admin_faq']],
            [['text' => '📢 پیام همگانی', 'callback_data' => 'admin_broadcast']],
            [['text' => '🔙 بازگشت', 'callback_data' => 'back_main']]
        ];
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $message,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // فوروارد پیام‌های کاربر به ادمین (پشتیبانی)
    // ─────────────────────────────────────────────────
    
    if(!$is_admin) {
        // فوروارد پیام اصلی
        apiRequest('forwardMessage', [
            'chat_id' => ADMIN_ID,
            'from_chat_id' => $chat_id,
            'message_id' => $message['message_id']
        ]);
        
        // اطلاعات کاربر و دکمه پاسخ
        apiRequest('sendMessage', [
            'chat_id' => ADMIN_ID,
            'text' => "
📨 <b>پیام جدید از کاربر</b>

👤 کاربر: <a href='tg://user?id=$user_id'>$first_name</a>
🆔 آیدی: <code>$user_id</code>
👤 یوزرنیم: @$username
🕐 زمان: " . date('Y/m/d H:i:s') . "
",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '✉️ پاسخ سریع', 'callback_data' => "reply_user_$user_id"]]
                ]
            ])
        ]);
        
        // تایید برای کاربر
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پیام شما برای پشتیبانی ارسال شد. لطفاً منتظر پاسخ بمانید."
        ]);
        
        exit;
    }
}

// ═══════════════════════════════════════════════════
// 🖱 CALLBACK HANDLER
// ═══════════════════════════════════════════════════

if($callback) {
    $data = $callback['data'];
    $chat_id = $callback['message']['chat']['id'];
    $user_id = $callback['from']['id'];
    $message_id = $callback['message']['message_id'];
    
    // پاسخ به callback
    apiRequest('answerCallbackQuery', ['callback_query_id' => $callback['id']]);
    
    // ─────────────────────────────────────────────────
    // 🔥 دکمه پاسخ به کاربر (برای ادمین)
    // ─────────────────────────────────────────────────
    
    if(strpos($data, 'reply_user_') === 0 && $user_id == ADMIN_ID) {
        $target_user = str_replace('reply_user_', '', $data);
        
        $reply_mode_file = DATA_DIR . 'admin_reply_mode.txt';
        file_put_contents($reply_mode_file, $target_user);
        
        apiRequest('sendMessage', [
            'chat_id' => ADMIN_ID,
            'text' => "
✉️ <b>حالت پاسخ فعال شد</b>

━━━━━━━━━━━━━━━━━━━━
👤 <b>پاسخ به کاربر:</b> <code>$target_user</code>

📝 پیام خود را برای این کاربر بنویسید.
می‌توانید متن، عکس، ویس، ویدیو یا فایل ارسال کنید.

پیام بعدی شما مستقیماً برای او ارسال می‌شود.

━━━━━━━━━━━━━━━━━━━━
❌ برای لغو، /start را بزنید.
",
            'parse_mode' => 'HTML'
        ]);
        
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // بررسی عضویت کانال
    // ─────────────────────────────────────────────────
    
    if($data == 'check_channel') {
        if(isUserInChannel($user_id)) {
            apiRequest('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "✅ <b>عضویت شما تایید شد!</b>\n\nحالا می‌توانید از تمام امکانات ربات استفاده کنید.\n\n/start را بزنید تا شروع کنید.",
                'parse_mode' => 'HTML'
            ]);
        } else {
            apiRequest('answerCallbackQuery', [
                'callback_query_id' => $callback['id'],
                'text' => '❌ هنوز عضو کانال نشده‌اید!',
                'show_alert' => true
            ]);
        }
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // خرید سرویس‌ها
    // ─────────────────────────────────────────────────
    
    if($data == 'buy_hack' || $data == 'buy_security') {
        $service = $data == 'buy_hack' ? 'هک شبکه‌های اجتماعی' : 'امنیت اینستاگرام';
        $amount = $data == 'buy_hack' ? PRICE_HACK : PRICE_SECURITY;
        
        // بررسی اولین خرید
        $user_orders = getUserOrders($user_id);
        if(empty($user_orders)) {
            $amount = $amount - ($amount * DISCOUNT_FIRST_BUY / 100);
        }
        
        // ایجاد سفارش
        $order_id = createOrder($user_id, $service, $amount);
        
        // ارسال پیام تایید
        $message = getOrderCreatedMessage($order_id, $service, $amount);
        
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $message,
            'parse_mode' => 'HTML'
        ]);
        
        // نمایش گزینه‌های پرداخت
        showPaymentOptions($chat_id, $order_id);
        
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // روش‌های پرداخت
    // ─────────────────────────────────────────────────
    
    if(strpos($data, 'pay_online_') === 0) {
        $order_id = str_replace('pay_online_', '', $data);
        processOnlinePayment($chat_id, $user_id, $order_id);
        exit;
    }
    
    if(strpos($data, 'pay_card_') === 0) {
        $order_id = str_replace('pay_card_', '', $data);
        processCardToCardPayment($chat_id, $user_id, $order_id);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // تایید/رد پرداخت (ادمین)
    // ─────────────────────────────────────────────────
    
    if(strpos($data, 'approve_payment_') === 0 && $user_id == ADMIN_ID) {
        $order_id = str_replace('approve_payment_', '', $data);
        approvePayment($order_id, $user_id);
        exit;
    }
    
    if(strpos($data, 'reject_payment_') === 0 && $user_id == ADMIN_ID) {
        $order_id = str_replace('reject_payment_', '', $data);
        rejectPayment($order_id, $user_id);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // جزئیات سفارش
    // ─────────────────────────────────────────────────
    
    if(strpos($data, 'order_details_') === 0) {
        $order_id = str_replace('order_details_', '', $data);
        showOrderDetails($chat_id, $order_id);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // مدیریت سفارشات (ادمین)
    // ─────────────────────────────────────────────────
    
    if($data == 'admin_orders' && $user_id == ADMIN_ID) {
        showAdminOrderPanel($chat_id);
        exit;
    }
    
    if(strpos($data, 'admin_orders_') === 0 && $user_id == ADMIN_ID) {
        $status = str_replace('admin_orders_', '', $data);
        showOrdersByStatus($chat_id, $status);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // FAQ
    // ─────────────────────────────────────────────────
    
    if($data == 'faq_main') {
        showFAQCategories($chat_id);
        exit;
    }
    
    if(strpos($data, 'faq_cat_') === 0) {
        $category = str_replace('faq_cat_', '', $data);
        showFAQByCategory($chat_id, $category);
        exit;
    }
    
    if($data == 'faq_all') {
        showAllFAQs($chat_id);
        exit;
    }
    
    if(strpos($data, 'faq_') === 0 && $data != 'faq_main' && $data != 'faq_all') {
        $index = (int)str_replace('faq_', '', $data);
        showFAQAnswer($chat_id, $index);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // مدیریت FAQ (ادمین)
    // ─────────────────────────────────────────────────
    
    if($data == 'admin_faq' && $user_id == ADMIN_ID) {
        showAdminFAQPanel($chat_id);
        exit;
    }
    
    // ─────────────────────────────────────────────────
    // سایر callback ها
    // ─────────────────────────────────────────────────
    
    if($data == 'my_orders') {
        showUserOrders($chat_id, $user_id);
        exit;
    }
    
    if($data == 'contact_support') {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "
💬 <b>تماس با پشتیبانی</b>

پیام خود را ارسال کنید. تیم ما در اسرع وقت پاسخگو خواهد بود.

⏰ پاسخگویی: کمتر از ۳۰ دقیقه
",
            'parse_mode' => 'HTML'
        ]);
        exit;
    }
    
    if($data == 'back_main') {
        apiRequest('sendMessage', [
            'chat_id' => $chat_id,
            'text' => getWelcomeMessage(),
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'keyboard' => [
                    [['text' => '💼 خدمات ما'], ['text' => '📦 سفارشات من']],
                    [['text' => '📢 نمونه‌کار'], ['text' => '❓ سوالات متداول']],
                    [['text' => '💬 پشتیبانی'], ['text' => '📊 درباره ما']],
                ],
                'resize_keyboard' => true
            ])
        ]);
        exit;
    }
    
    if($data == 'back_services') {
        apiRequest('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => "
💼 <b>خدمات ربات رابین هک</b>

لطفاً یکی از خدمات زیر را انتخاب کنید:

━━━━━━━━━━━━━━━━━━━━
🕵️ <b>هک شبکه‌های اجتماعی</b>
دسترسی به تلگرام، اینستاگرام و...

🛡️ <b>امنیت اینستاگرام</b>
بازگردانی پیج، حذف فیک، ضد هک

━━━━━━━━━━━━━━━━━━━━
🎁 تخفیف ویژه اولین خرید: ۲۰٪
",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '🕵️ هک شبکه‌های اجتماعی', 'callback_data' => 'buy_hack']],
                    [['text' => '🛡️ امنیت اینستاگرام', 'callback_data' => 'buy_security']],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'back_main']]
                ]
            ])
        ]);
        exit;
    }
}

// ═══════════════════════════════════════════════════
// 🔚 END OF BOT MAIN FILE
// ═══════════════════════════════════════════════════
?>